%% PLOTTING C60 SENSOR'S FREQUENCY RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'freq_meas_NO_Vctrl=18V_Vref=1V.csv',...               % Target: NO (O down) (Vctrl=18) with 2-phase pulse generator;                
         'freq_meas_NO_Vctrl=19V_Vref=1V.csv',...               % Target: NO (N down) (Vctrl=19) with 2-phase pulse generator;
         'freq_meas_NO_Vctrl=20V_Vref=1V.csv',...               % Target: NO (flat) (Vctrl=20) with 2-phase pulse generator;
         'freq_meas_NO2_Vctrl=27V_Vref=1.7V.csv',...            % Target: NO2 (O down) (Vctrl=27) with 2-phase pulse generator;                
         'freq_meas_NO2_Vctrl=28V_Vref=1.7V.csv',...            % Target: NO2 (N down) (Vctrl=28) with 2-phase pulse generator;
         'freq_meas_NO2_Vctrl=29V_Vref=1.7V.csv',...            % Target: NO2 (flat) (Vctrl=29) with 2-phase pulse generator;
         
         'freq_meas_NO_Vctrl=18V_Vref=1V_PWL.csv',...           % Target: NO (O down) (Vctrl=18) with PWL generator;                
         'freq_meas_NO_Vctrl=19V_Vref=1V_PWL.csv',...           % Target: NO (N down) (Vctrl=19) with PWL generator;
         'freq_meas_NO_Vctrl=20V_Vref=1V_PWL.csv',...           % Target: NO (flat) (Vctrl=20) with PWL generator;
         'freq_meas_NO2_Vctrl=27V_Vref=1.7V_PWL.csv',...        % Target: NO2 (O down) (Vctrl=27) with PWL generator;                
         'freq_meas_NO2_Vctrl=28V_Vref=1.7V_PWL.csv',...        % Target: NO2 (N down) (Vctrl=28) with PWL generator;
         'freq_meas_NO2_Vctrl=29V_Vref=1.7V_PWL.csv',...        % Target: NO2 (flat) (Vctrl=29) with PWL generator;

         };       
     
[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file
 
 
%% Extracting data
importfile(file);
[raws,columns] = size(data);

switch file

    case {'freq_meas_NO_Vctrl=18V_Vref=1V.csv','freq_meas_NO_Vctrl=18V_Vref=1V_PWL.csv'}
            
        label_target = ' NO (O down)';

    case {'freq_meas_NO_Vctrl=19V_Vref=1V.csv','freq_meas_NO_Vctrl=19V_Vref=1V_PWL.csv'}
        
        label_target = ' NO (N down)';
    
    case {'freq_meas_NO_Vctrl=20V_Vref=1V.csv','freq_meas_NO_Vctrl=20V_Vref=1V_PWL.csv'}

        label_target = ' NO (flat)';

    case {'freq_meas_NO2_Vctrl=27V_Vref=1.7V.csv','freq_meas_NO2_Vctrl=27V_Vref=1.7V_PWL.csv'}
            
        label_target = ' NO_{2} (O down)';

    case {'freq_meas_NO2_Vctrl=28V_Vref=1.7V.csv','freq_meas_NO2_Vctrl=28V_Vref=1.7V_PWL.csv'}
        
        label_target = ' NO_{2} (N down)';
    
    case {'freq_meas_NO2_Vctrl=29V_Vref=1.7V.csv','freq_meas_NO2_Vctrl=29V_Vref=1.7V_PWL.csv'}

        label_target = ' NO_{2} (flat)';

end


labels_atmgases = {'Ar ',...                         % Vctrl = 3 V;
                   'CO ',...                         % Vctrl = 4 V;
                   'CO_{2} ',...                     % Vctrl = 5 V;
                   'N_{2} ',...                      % Vctrl = 6 V;
                   'H_{2}O (flat) ',...              % Vctrl = 7 V;
                   'H_{2}O (H down) ',...            % Vctrl = 8 V;
                   'H_{2}O (O down) ',...            % Vctrl = 9 V;
                   'O_{2} ',...                      % Vctrl = 10 V;
                   };


color_atm = {'green_-','red_-','yellow_-','blue_-','cyan_-','cyan_--','cyan_-.','magenta_-'};


i = 1;


for i_atmgases = 1:2:columns 

    Freq(:,i) = data(:,i_atmgases+1);     % Measured frequency signature [Hz]
    time(:,i) = data(:,i_atmgases);       % Time [s]

    labels(:,i) = strcat(labels_atmgases(:,i),'vs',label_target); 


    figure(1);
    c=find(color_atm{1,i}=='_');
    plot(time(:,i)*1e6,Freq(:,i)/1e6,...        % Time in us, Frequency in MHz
         'DisplayName',char(labels(:,i)),'LineWidth',1.5,...
         'Color',char(color_atm{1,i}(1:c-1)),'LineStyle',char(color_atm{1,i}(c+1:end)));
    xlabel('Time [\mus]');
    ylabel('Frequency [MHz]');
    hold on;
    grid on;
    legend('-DynamicLegend');
    legend('show');
    legend('Location','southeast');

    i = i + 1;

end







